Ext.data.JsonP.sol_common_WfUtils({"tagname":"class","name":"sol.common.WfUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.WfUtils.js","href":"lib_sol.common.WfUtils.html#sol-common-WfUtils"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.04.000"],"eloix":true,"eloas":true,"elojc":true,"requires":["sol.common.Config","sol.common.ConfigMixin","sol.common.DateUtils","sol.common.ObjectUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.UserProfile","sol.common.UserUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.WfUtils","id":"property-logger","meta":{"private":true}},{"name":"wfDiagramTypeId","tagname":"property","owner":"sol.common.WfUtils","id":"property-wfDiagramTypeId","meta":{"private":true}},{"name":"wfEscalationTypeId","tagname":"property","owner":"sol.common.WfUtils","id":"property-wfEscalationTypeId","meta":{"private":true}},{"name":"wfEscalationUserTypeId","tagname":"property","owner":"sol.common.WfUtils","id":"property-wfEscalationUserTypeId","meta":{"private":true}},{"name":"wfNodeTypeId","tagname":"property","owner":"sol.common.WfUtils","id":"property-wfNodeTypeId","meta":{"private":true}},{"name":"wfVersionTypeId","tagname":"property","owner":"sol.common.WfUtils","id":"property-wfVersionTypeId","meta":{"private":true}},{"name":"workflowIconFolderGuid","tagname":"property","owner":"sol.common.WfUtils","id":"property-workflowIconFolderGuid","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"activateAssocs","tagname":"method","owner":"sol.common.WfUtils","id":"method-activateAssocs","meta":{}},{"name":"addWorkflowTemplateVersions","tagname":"method","owner":"sol.common.WfUtils","id":"method-addWorkflowTemplateVersions","meta":{}},{"name":"appendCycleNumber","tagname":"method","owner":"sol.common.WfUtils","id":"method-appendCycleNumber","meta":{}},{"name":"appendNodeComment","tagname":"method","owner":"sol.common.WfUtils","id":"method-appendNodeComment","meta":{}},{"name":"cancelWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-cancelWorkflow","meta":{}},{"name":"changeNodeName","tagname":"method","owner":"sol.common.WfUtils","id":"method-changeNodeName","meta":{}},{"name":"changeNodeUser","tagname":"method","owner":"sol.common.WfUtils","id":"method-changeNodeUser","meta":{}},{"name":"changeWorkflowPriority","tagname":"method","owner":"sol.common.WfUtils","id":"method-changeWorkflowPriority","meta":{}},{"name":"checkMainAdminWf","tagname":"method","owner":"sol.common.WfUtils","id":"method-checkMainAdminWf","meta":{}},{"name":"checkWfIsRunning","tagname":"method","owner":"sol.common.WfUtils","id":"method-checkWfIsRunning","meta":{}},{"name":"createReminder","tagname":"method","owner":"sol.common.WfUtils","id":"method-createReminder","meta":{}},{"name":"createServiceWfName","tagname":"method","owner":"sol.common.WfUtils","id":"method-createServiceWfName","meta":{}},{"name":"deleteWorkflowTemplate","tagname":"method","owner":"sol.common.WfUtils","id":"method-deleteWorkflowTemplate","meta":{}},{"name":"exportWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-exportWorkflow","meta":{}},{"name":"exportWorkflowTemplate","tagname":"method","owner":"sol.common.WfUtils","id":"method-exportWorkflowTemplate","meta":{}},{"name":"findFirstActiveNode","tagname":"method","owner":"sol.common.WfUtils","id":"method-findFirstActiveNode","meta":{}},{"name":"findFirstActiveNodeWithUrl","tagname":"method","owner":"sol.common.WfUtils","id":"method-findFirstActiveNodeWithUrl","meta":{}},{"name":"findWorkflows","tagname":"method","owner":"sol.common.WfUtils","id":"method-findWorkflows","meta":{}},{"name":"forwardWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-forwardWorkflow","meta":{}},{"name":"getActiveNodes","tagname":"method","owner":"sol.common.WfUtils","id":"method-getActiveNodes","meta":{}},{"name":"getActiveUserNodes","tagname":"method","owner":"sol.common.WfUtils","id":"method-getActiveUserNodes","meta":{}},{"name":"getActiveWorkflows","tagname":"method","owner":"sol.common.WfUtils","id":"method-getActiveWorkflows","meta":{}},{"name":"getCycleNumber","tagname":"method","owner":"sol.common.WfUtils","id":"method-getCycleNumber","meta":{}},{"name":"getFormName","tagname":"method","owner":"sol.common.WfUtils","id":"method-getFormName","meta":{}},{"name":"getFormUrl","tagname":"method","owner":"sol.common.WfUtils","id":"method-getFormUrl","meta":{}},{"name":"getLastActiveWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-getLastActiveWorkflow","meta":{}},{"name":"getNextWorkflowVersionNo","tagname":"method","owner":"sol.common.WfUtils","id":"method-getNextWorkflowVersionNo","meta":{}},{"name":"getNode","tagname":"method","owner":"sol.common.WfUtils","id":"method-getNode","meta":{}},{"name":"getNodeById","tagname":"method","owner":"sol.common.WfUtils","id":"method-getNodeById","meta":{}},{"name":"getNodeByName","tagname":"method","owner":"sol.common.WfUtils","id":"method-getNodeByName","meta":{}},{"name":"getNodeName","tagname":"method","owner":"sol.common.WfUtils","id":"method-getNodeName","meta":{}},{"name":"getNodeUser","tagname":"method","owner":"sol.common.WfUtils","id":"method-getNodeUser","meta":{}},{"name":"getServiceWfPrefix","tagname":"method","owner":"sol.common.WfUtils","id":"method-getServiceWfPrefix","meta":{}},{"name":"getSuccessorNode","tagname":"method","owner":"sol.common.WfUtils","id":"method-getSuccessorNode","meta":{}},{"name":"getSuccessorNodes","tagname":"method","owner":"sol.common.WfUtils","id":"method-getSuccessorNodes","meta":{}},{"name":"getSuccessorNodes2","tagname":"method","owner":"sol.common.WfUtils","id":"method-getSuccessorNodes2","meta":{}},{"name":"getTemplateSord","tagname":"method","owner":"sol.common.WfUtils","id":"method-getTemplateSord","meta":{}},{"name":"getTemplateWfDiagramNode","tagname":"method","owner":"sol.common.WfUtils","id":"method-getTemplateWfDiagramNode","meta":{}},{"name":"getTemplates","tagname":"method","owner":"sol.common.WfUtils","id":"method-getTemplates","meta":{}},{"name":"getUniqueNodes","tagname":"method","owner":"sol.common.WfUtils","id":"method-getUniqueNodes","meta":{}},{"name":"getWfBaseUrl","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWfBaseUrl","meta":{}},{"name":"getWfMapValue","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWfMapValue","meta":{}},{"name":"getWfNameFromJson","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWfNameFromJson","meta":{}},{"name":"getWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflow","meta":{}},{"name":"getWorkflowAsJson","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflowAsJson","meta":{}},{"name":"getWorkflowIconGuid","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflowIconGuid","meta":{}},{"name":"getWorkflowStatus","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflowStatus","meta":{}},{"name":"getWorkflowTemplate","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflowTemplate","meta":{}},{"name":"getWorkflowTemplateId","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflowTemplateId","meta":{}},{"name":"getWorkflowTemplateName","tagname":"method","owner":"sol.common.WfUtils","id":"method-getWorkflowTemplateName","meta":{}},{"name":"hasActiveWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-hasActiveWorkflow","meta":{}},{"name":"importWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-importWorkflow","meta":{}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isServiceWf","tagname":"method","owner":"sol.common.WfUtils","id":"method-isServiceWf","meta":{}},{"name":"loadBaseConfig","tagname":"method","owner":"sol.common.WfUtils","id":"method-loadBaseConfig","meta":{"private":true}},{"name":"mergeWorkflowTemplate","tagname":"method","owner":"sol.common.WfUtils","id":"method-mergeWorkflowTemplate","meta":{}},{"name":"parseAndCheckParams","tagname":"method","owner":"sol.common.WfUtils","id":"method-parseAndCheckParams","meta":{}},{"name":"readWorkflowIconGuids","tagname":"method","owner":"sol.common.WfUtils","id":"method-readWorkflowIconGuids","meta":{"private":true}},{"name":"renameWorkflowTemplate","tagname":"method","owner":"sol.common.WfUtils","id":"method-renameWorkflowTemplate","meta":{}},{"name":"replaceSubTemplateNamesInWorkflowJson","tagname":"method","owner":"sol.common.WfUtils","id":"method-replaceSubTemplateNamesInWorkflowJson","meta":{}},{"name":"setSessionOptionStartDocMaskWorkflows","tagname":"method","owner":"sol.common.WfUtils","id":"method-setSessionOptionStartDocMaskWorkflows","meta":{}},{"name":"setWfMapValue","tagname":"method","owner":"sol.common.WfUtils","id":"method-setWfMapValue","meta":{}},{"name":"setWorkflowStatus","tagname":"method","owner":"sol.common.WfUtils","id":"method-setWorkflowStatus","meta":{}},{"name":"startMaskStandardWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-startMaskStandardWorkflow","meta":{}},{"name":"startWorkflow","tagname":"method","owner":"sol.common.WfUtils","id":"method-startWorkflow","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.WfUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.WfUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.ConfigMixin' rel='sol.common.ConfigMixin' class='docClass'>sol.common.ConfigMixin</a></div><div class='dependency'><a href='#!/api/sol.common.DateUtils' rel='sol.common.DateUtils' class='docClass'>sol.common.DateUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.UserProfile' rel='sol.common.UserProfile' class='docClass'>sol.common.UserProfile</a></div><div class='dependency'><a href='#!/api/sol.common.UserUtils' rel='sol.common.UserUtils' class='docClass'>sol.common.UserUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils' target='_blank'>lib_sol.common.WfUtils.js</a></div></pre><div class='doc-contents'><p>Contains workflow related utility functions</p>\n      <p class='version-tag'>Version: <b>1.04.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-logger' class='name expandable'>logger</a> : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>\n</div><div class='long'>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div><div id='property-wfDiagramTypeId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-wfDiagramTypeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-wfDiagramTypeId' class='name expandable'>wfDiagramTypeId</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>1663767661</code></p></div></div></div><div id='property-wfEscalationTypeId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-wfEscalationTypeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-wfEscalationTypeId' class='name expandable'>wfEscalationTypeId</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>633363356</code></p></div></div></div><div id='property-wfEscalationUserTypeId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-wfEscalationUserTypeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-wfEscalationUserTypeId' class='name expandable'>wfEscalationUserTypeId</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>123879203</code></p></div></div></div><div id='property-wfNodeTypeId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-wfNodeTypeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-wfNodeTypeId' class='name expandable'>wfNodeTypeId</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>2015686193</code></p></div></div></div><div id='property-wfVersionTypeId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-wfVersionTypeId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-wfVersionTypeId' class='name expandable'>wfVersionTypeId</a> : Number<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>914434915</code></p></div></div></div><div id='property-workflowIconFolderGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-property-workflowIconFolderGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-property-workflowIconFolderGuid' class='name expandable'>workflowIconFolderGuid</a> : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>&quot;(E10E1000-E100-E100-E100-E10E10E10EE0)&quot;</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-activateAssocs' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-activateAssocs' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-activateAssocs' class='name expandable'>activateAssocs</a>( <span class='pre'>assocs</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Activates associations ...</div><div class='long'><p>Activates associations</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>assocs</span> : de.elo.ix.client.WFNodeAssoc[]<div class='sub-desc'><p>Associations</p>\n</div></li></ul></div></div></div><div id='method-addWorkflowTemplateVersions' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-addWorkflowTemplateVersions' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-addWorkflowTemplateVersions' class='name expandable'>addWorkflowTemplateVersions</a>( <span class='pre'>mergeWorkflowTemplate, originWorkflowTemplate</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Save a workflow template as a workflow template version ...</div><div class='long'><p>Save a workflow template as a workflow template version</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mergeWorkflowTemplate</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>Merge workflow template</p>\n</div></li><li><span class='pre'>originWorkflowTemplate</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>Origin workflow template</p>\n</div></li></ul></div></div></div><div id='method-appendCycleNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-appendCycleNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-appendCycleNumber' class='name expandable'>appendCycleNumber</a>( <span class='pre'>nodeName, cycleNo</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Appends the cycle number to a node name ...</div><div class='long'><p>Appends the cycle number to a node name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodeName</span> : String<div class='sub-desc'><p>Node name</p>\n</div></li><li><span class='pre'>cycleNo</span> : String<div class='sub-desc'><p>Cycle number</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-appendNodeComment' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-appendNodeComment' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-appendNodeComment' class='name expandable'>appendNodeComment</a>( <span class='pre'>node, comment, [override]</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Appends a String to a nodes comment field. ...</div><div class='long'><p>Appends a String to a nodes comment field.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : de.elo.ix.client.WFNode<div class='sub-desc'><p>The node to be changed</p>\n</div></li><li><span class='pre'>comment</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>override</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, an existing comment will be overridden</p>\n</div></li></ul></div></div></div><div id='method-cancelWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-cancelWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-cancelWorkflow' class='name expandable'>cancelWorkflow</a>( <span class='pre'>flowId, [force]</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Cancels a workflow. ...</div><div class='long'><p>Cancels a workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>force</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, the workflow will be terminated ignoring existing locks</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The canceled workflows ID</p>\n</div></li></ul></div></div></div><div id='method-changeNodeName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-changeNodeName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-changeNodeName' class='name expandable'>changeNodeName</a>( <span class='pre'>node, name</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Changes the name of a node. ...</div><div class='long'><p>Changes the name of a node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : de.elo.ix.client.WFNode<div class='sub-desc'><p>The node to be changed</p>\n</div></li><li><span class='pre'>name</span> : String<div class='sub-desc'><p>The new node name</p>\n</div></li></ul></div></div></div><div id='method-changeNodeUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-changeNodeUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-changeNodeUser' class='name expandable'>changeNodeUser</a>( <span class='pre'>node, user, params</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Changes the user of a node. ...</div><div class='long'><p>Changes the user of a node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : de.elo.ix.client.WFNode<div class='sub-desc'><p>The node to be changed</p>\n</div></li><li><span class='pre'>user</span> : String<div class='sub-desc'><p>The user which should be set</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>changeDesignDepartment</span> : Boolean (optional)<div class='sub-desc'><p>Change also the property <code>designDepartment</code></p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul></div></div></div><div id='method-changeWorkflowPriority' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-changeWorkflowPriority' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-changeWorkflowPriority' class='name expandable'>changeWorkflowPriority</a>( <span class='pre'>flowId, prio</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Changes the priority of a workflow. ...</div><div class='long'><p>Changes the priority of a workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>The workflows ID</p>\n</div></li><li><span class='pre'>prio</span> : Number<div class='sub-desc'><p>The new priority (0=high, 1=medium, 2=low)</p>\n</div></li></ul></div></div></div><div id='method-checkMainAdminWf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-checkMainAdminWf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-checkMainAdminWf' class='name expandable'>checkMainAdminWf</a>( <span class='pre'>wfDiagram</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if the workflow template was created of a user with main admin rights. ...</div><div class='long'><p>Checks, if the workflow template was created of a user with main admin rights.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-checkWfIsRunning' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-checkWfIsRunning' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-checkWfIsRunning' class='name expandable'>checkWfIsRunning</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks wether the ELOwf is running ...</div><div class='long'><p>Checks wether the ELOwf is running</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createReminder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-createReminder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-createReminder' class='name expandable'>createReminder</a>( <span class='pre'>objId, [params]</span> ) : Number[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new reminder. ...</div><div class='long'><p>Creates a new reminder.</p>\n        <p>Available since: <b>1.04.000</b></p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>Additional parameters</p>\n<ul><li><span class='pre'>userIds</span> : String[] (optional)<div class='sub-desc'><p>The user ids of the reminder receivers. Default is the IX connection user.</p>\n</div></li><li><span class='pre'>name</span> : String (optional)<div class='sub-desc'><p>The name for the reminder. Default is <code>sord.name</code>.</p>\n</div></li><li><span class='pre'>promptDateIso</span> : String (optional)<div class='sub-desc'><p>The date (as ISO string) when the reminder will be set visible for the user. Defualt is the current date.</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number[]</span><div class='sub-desc'><p>The reminder ids. There will be one reminderfor each user in <code>params.userIds</code> if defined or one reminder for the current user.</p>\n</div></li></ul></div></div></div><div id='method-createServiceWfName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-createServiceWfName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-createServiceWfName' class='name expandable'>createServiceWfName</a>( <span class='pre'>wfName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates the name for a service workflow from a given name. ...</div><div class='long'><p>Creates the name for a service workflow from a given name.</p>\n\n<p>Currently this is implemented by using the value retrieved by <a href=\"#!/api/sol.common.WfUtils-method-getServiceWfPrefix\" rel=\"sol.common.WfUtils-method-getServiceWfPrefix\" class=\"docClass\">getServiceWfPrefix</a> as prefix.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-deleteWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-deleteWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-deleteWorkflowTemplate' class='name expandable'>deleteWorkflowTemplate</a>( <span class='pre'>workflowTemplateId</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Deletes a workflow template ID ...</div><div class='long'><p>Deletes a workflow template ID</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplateId</span> : String<div class='sub-desc'><p>Workflow template ID</p>\n</div></li></ul></div></div></div><div id='method-exportWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-exportWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-exportWorkflow' class='name expandable'>exportWorkflow</a>( <span class='pre'>workflowId, file, config, clearAdminName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Exports a workflow into a specified file ...</div><div class='long'><p>Exports a workflow into a specified file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowId</span> : String<div class='sub-desc'><p>Workflow ID</p>\n</div></li><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'><p>Export file</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li><li><span class='pre'>clearAdminName</span> : Boolean<div class='sub-desc'><p>Clear the administrator user name</p>\n</div></li></ul></div></div></div><div id='method-exportWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-exportWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-exportWorkflowTemplate' class='name expandable'>exportWorkflowTemplate</a>( <span class='pre'>workflowTemplateName, file, config, clearAdminName</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Exports a workflow template into a specified file ...</div><div class='long'><p>Exports a workflow template into a specified file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplateName</span> : String<div class='sub-desc'><p>Name of the workflow template</p>\n</div></li><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'><p>Export file</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li><li><span class='pre'>clearAdminName</span> : Boolean<div class='sub-desc'><p>Clear the administrator user name</p>\n</div></li></ul></div></div></div><div id='method-findFirstActiveNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-findFirstActiveNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-findFirstActiveNode' class='name expandable'>findFirstActiveNode</a>( <span class='pre'>objId, flowId</span> ) : de.elo.ix.client.WFCollectNode<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds the first active Node of a specific object and workflow ...</div><div class='long'><p>Finds the first active Node of a specific object and workflow</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFCollectNode</span><div class='sub-desc'><p>wfCollectNode. Found active node.</p>\n</div></li></ul></div></div></div><div id='method-findFirstActiveNodeWithUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-findFirstActiveNodeWithUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-findFirstActiveNodeWithUrl' class='name expandable'>findFirstActiveNodeWithUrl</a>( <span class='pre'>objId, flowId</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Finds the first active node of a specific object and workflow\nand returns the node ID and the URL. ...</div><div class='long'><p>Finds the first active node of a specific object and workflow\nand returns the node ID and the URL.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>nodeId, url. Node ID and URL</p>\n</div></li></ul></div></div></div><div id='method-findWorkflows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-findWorkflows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-findWorkflows' class='name expandable'>findWorkflows</a>( <span class='pre'>findWorkflowInfo, [checkoutOptions], [ixConn]</span> ) : de.elo.ix.client.WFDiagram[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves workflows with a search request. ...</div><div class='long'><p>Retrieves workflows with a search request.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>findWorkflowInfo</span> : de.elo.ix.client.FindWorkflowInfo<div class='sub-desc'><p>Defines the search</p>\n</div></li><li><span class='pre'>checkoutOptions</span> : de.elo.ix.client.WFDiagramC (optional)<div class='sub-desc'><p>Defines the members which will be returned in the result</p>\n<p>Defaults to: <code>WFDiagramC.mbLean</code></p></div></li><li><span class='pre'>ixConn</span> : de.elo.ix.client.IXConnection (optional)<div class='sub-desc'>\n<p>Defaults to: <code>ixConnect</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFDiagram[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-forwardWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-forwardWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-forwardWorkflow' class='name expandable'>forwardWorkflow</a>( <span class='pre'>flowId, currentNodeId, destinationNodeIds</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Forward a workflow ...</div><div class='long'><p>Forward a workflow</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>currentNodeId</span> : String<div class='sub-desc'><p>Current node ID</p>\n</div></li><li><span class='pre'>destinationNodeIds</span> : Array<div class='sub-desc'><p>Destination node ID</p>\n</div></li></ul></div></div></div><div id='method-getActiveNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getActiveNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getActiveNodes' class='name expandable'>getActiveNodes</a>( <span class='pre'>workflow</span> ) : de.elo.ix.client.WFNode[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns all active workflow nodes. ...</div><div class='long'><p>Returns all active workflow nodes.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getActiveUserNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getActiveUserNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getActiveUserNodes' class='name expandable'>getActiveUserNodes</a>( <span class='pre'>workflow</span> ) : de.elo.ix.client.WFNode[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns all active workflow nodes with assigned users or groups. ...</div><div class='long'><p>Returns all active workflow nodes with assigned users or groups.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getActiveWorkflows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getActiveWorkflows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getActiveWorkflows' class='name expandable'>getActiveWorkflows</a>( <span class='pre'>objId, [filter]</span> ) : de.elo.ix.client.WFDiagram[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the active workflows for an object. ...</div><div class='long'><p>Retrieves the active workflows for an object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>filter</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>template</span> : String (optional)<div class='sub-desc'><p>Filter results by name or ID of the workflow template</p>\n</div></li><li><span class='pre'>user</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code> the active workflows will be filtered by the current user</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFDiagram[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getCycleNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getCycleNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getCycleNumber' class='name expandable'>getCycleNumber</a>( <span class='pre'>nodeName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the cycle number ...</div><div class='long'><p>Returns the cycle number</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodeName</span> : String<div class='sub-desc'><p>Node name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getFormName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getFormName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getFormName' class='name expandable'>getFormName</a>( <span class='pre'>wfCollectNode</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns form name of a specified node ...</div><div class='long'><p>Returns form name of a specified node</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfCollectNode</span> : de.elo.ix.client.WFCollectNode<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>formName. Form name.</p>\n</div></li></ul></div></div></div><div id='method-getFormUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getFormUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getFormUrl' class='name expandable'>getFormUrl</a>( <span class='pre'>wfCollectNode</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the ELOwf form URL of a specified node ...</div><div class='long'><p>Returns the ELOwf form URL of a specified node</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfCollectNode</span> : de.elo.ix.client.WFCollectNode<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>url URL of the ELOwf form</p>\n</div></li></ul></div></div></div><div id='method-getLastActiveWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getLastActiveWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getLastActiveWorkflow' class='name expandable'>getLastActiveWorkflow</a>( <span class='pre'>objId</span> ) : de.elo.ix.client.WFDiagram<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the last active workflow for an object ...</div><div class='long'><p>Returns the last active workflow for an object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFDiagram</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getNextWorkflowVersionNo' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getNextWorkflowVersionNo' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getNextWorkflowVersionNo' class='name expandable'>getNextWorkflowVersionNo</a>( <span class='pre'>workflowTemplate</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the highest workflow template version number ...</div><div class='long'><p>Returns the highest workflow template version number</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplate</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>Workflow template</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>Next workflow version number</p>\n</div></li></ul></div></div></div><div id='method-getNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getNode' class='name expandable'>getNode</a>( <span class='pre'>workflow, id</span> ) : de.elo.ix.client.WFNode<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the node defined by the nodeId. ...</div><div class='long'><p>Returns the node defined by the nodeId.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>id</span> : String<div class='sub-desc'><p>The ID of the node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode</span><div class='sub-desc'><p>The node or null, if no node was found with the ID</p>\n</div></li></ul></div></div></div><div id='method-getNodeById' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getNodeById' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getNodeById' class='name expandable'>getNodeById</a>( <span class='pre'>workflow, nodeId</span> ) : de.elo.ix.client.WFNode<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the node for a node ID. ...</div><div class='long'><p>Returns the node for a node ID.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'><p>Node ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode</span><div class='sub-desc'><p>The node or null, if no node was found with the ID</p>\n</div></li></ul></div></div></div><div id='method-getNodeByName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getNodeByName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getNodeByName' class='name expandable'>getNodeByName</a>( <span class='pre'>workflow, name, cycleNo</span> ) : de.elo.ix.client.WFNode<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the node for a node name. ...</div><div class='long'><p>Returns the node for a node name.\nIf the node name is not unique, the first found node will be returned.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>name</span> : String<div class='sub-desc'><p>The name of the node</p>\n</div></li><li><span class='pre'>cycleNo</span> : String<div class='sub-desc'><p>Cycle number</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode</span><div class='sub-desc'><p>The node or null, if no node was found with the name</p>\n</div></li></ul></div></div></div><div id='method-getNodeName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getNodeName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getNodeName' class='name expandable'>getNodeName</a>( <span class='pre'>workflow, nodeId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the name of the node. ...</div><div class='long'><p>Returns the name of the node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The name of the node or null, if no node was found with the ID</p>\n</div></li></ul></div></div></div><div id='method-getNodeUser' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getNodeUser' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getNodeUser' class='name expandable'>getNodeUser</a>( <span class='pre'>wfDiagram, nodeId, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Get node User ...</div><div class='long'><p>Get node User</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>Workflow diagram</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'><p>Node ID</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>useSessionUserAlternatively</span> : Boolean<div class='sub-desc'>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Node user</p>\n</div></li></ul></div></div></div><div id='method-getServiceWfPrefix' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getServiceWfPrefix' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getServiceWfPrefix' class='name expandable'>getServiceWfPrefix</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the prefix for service workflows from the serviceWfPrefix property from base.config file. ...</div><div class='long'><p>Retrieves the prefix for service workflows from the <code>serviceWfPrefix</code> property from <code>base.config</code> file.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSuccessorNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getSuccessorNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getSuccessorNode' class='name expandable'>getSuccessorNode</a>( <span class='pre'>workflow, nodeId, filterConfig</span> ) : de.elo.ix.client.WFNode<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the successor node ...</div><div class='long'><p>Returns the successor node</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'><p>The ID of the node</p>\n</div></li><li><span class='pre'>filterConfig</span> : Object<div class='sub-desc'><p>Filte configuration</p>\n<ul><li><span class='pre'>nameTranslationKeys</span> : Array<div class='sub-desc'><p>Translation keys</p>\n</div></li><li><span class='pre'>iconNames</span> : Array<div class='sub-desc'><p>Icon names</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSuccessorNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getSuccessorNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getSuccessorNodes' class='name expandable'>getSuccessorNodes</a>( <span class='pre'>workflow, nodeId, [filterType]</span> ) : de.elo.ix.client.WFNode[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves a list of nodes which are successors to the node with the spezified ID. ...</div><div class='long'><p>Retrieves a list of nodes which are successors to the node with the spezified ID.\nThe returned nodes could be filtered by type.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'><p>The ID of the node</p>\n</div></li><li><span class='pre'>filterType</span> : Number (optional)<div class='sub-desc'><p>The number of the type (use de.elo.ix.client.WFNodeC.TYPE_* for the types)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSuccessorNodes2' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getSuccessorNodes2' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getSuccessorNodes2' class='name expandable'>getSuccessorNodes2</a>( <span class='pre'>workflow, nodeId, filterConfig</span> ) : de.elo.ix.client.WFNode[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the successor nodes ...</div><div class='long'><p>Returns the successor nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'><p>The ID of the node</p>\n</div></li><li><span class='pre'>filterConfig</span> : Object<div class='sub-desc'><p>Filte configuration</p>\n<ul><li><span class='pre'>nameTranslationKeys</span> : Array<div class='sub-desc'><p>Translation keys</p>\n</div></li><li><span class='pre'>iconNames</span> : Array<div class='sub-desc'><p>Icon names</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFNode[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplateSord' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getTemplateSord' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getTemplateSord' class='name expandable'>getTemplateSord</a>( <span class='pre'>sord, flowId, options</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a template sord including wfMap data ...</div><div class='long'><p>Returns a template sord including wfMap data</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'><p>sord for object formatter</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Workflow id of workflow map</p>\n</div></li><li><span class='pre'>options</span> : Object<div class='sub-desc'><p>Options</p>\n<ul><li><span class='pre'>asAdmin</span> : Boolean<div class='sub-desc'><p>As admin</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Template Sord</p>\n</div></li></ul></div></div></div><div id='method-getTemplateWfDiagramNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getTemplateWfDiagramNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getTemplateWfDiagramNode' class='name expandable'>getTemplateWfDiagramNode</a>( <span class='pre'>wfDiagram, nodeId</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a template workflow node from a WFDiagram (see TemplateWfDiagramNode). ...</div><div class='long'><p>Creates a template workflow node from a WFDiagram (see <a href=\"#!/api/sol.common.ObjectFormatter.TemplateWfDiagramNode\" rel=\"sol.common.ObjectFormatter.TemplateWfDiagramNode\" class=\"docClass\">TemplateWfDiagramNode</a>).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : Number<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTemplates' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getTemplates' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getTemplates' class='name expandable'>getTemplates</a>( <span class='pre'>params</span> ) : de.elo.ix.client.WFDiagram[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the available workflow templates. ...</div><div class='long'><p>Retrieves the available workflow templates.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>wfDiagramZ</span> : de.elo.ix.client.WFDiagramC (optional)<div class='sub-desc'><p>Defines the members which will be returned in the result</p>\n<p>Defaults to: <code>WFDiagramC.mbLean</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFDiagram[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getUniqueNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getUniqueNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getUniqueNodes' class='name expandable'>getUniqueNodes</a>( <span class='pre'>nodes</span> ) : Array<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a list of unique workflow nodes ...</div><div class='long'><p>Returns a list of unique workflow nodes</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>nodes</span> : Array<div class='sub-desc'><p>Workflow nodes</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Array</span><div class='sub-desc'><p>Unique workflow nodes</p>\n</div></li></ul></div></div></div><div id='method-getWfBaseUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWfBaseUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWfBaseUrl' class='name expandable'>getWfBaseUrl</a>( <span class='pre'></span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the ELOwf base URL ...</div><div class='long'><p>Returns the ELOwf base URL</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>url. ELOwf base URL.</p>\n</div></li></ul></div></div></div><div id='method-getWfMapValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWfMapValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWfMapValue' class='name expandable'>getWfMapValue</a>( <span class='pre'>flowId, key</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves a map value from a workflow. ...</div><div class='long'><p>Retrieves a map value from a workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Map key</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>value</p>\n</div></li></ul></div></div></div><div id='method-getWfNameFromJson' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWfNameFromJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWfNameFromJson' class='name expandable'>getWfNameFromJson</a>( <span class='pre'>workflowJson</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the workflow name ...</div><div class='long'><p>Returns the workflow name</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowJson</span> : String<div class='sub-desc'><p>Workflow JSON</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Workflow name</p>\n</div></li></ul></div></div></div><div id='method-getWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflow' class='name expandable'>getWorkflow</a>( <span class='pre'>flowId, [params]</span> ) : de.elo.ix.client.WFDiagram<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a specific workflow. ...</div><div class='long'><p>Returns a specific workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>inclFinished</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, the workflows will be returned, even if it is already finished</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.WFDiagram</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getWorkflowAsJson' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflowAsJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflowAsJson' class='name expandable'>getWorkflowAsJson</a>( <span class='pre'>flowId, config</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns workflow diagram as JSON string ...</div><div class='long'><p>Returns workflow diagram as JSON string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Workflow ID</p>\n</div></li><li><span class='pre'>config</span> : String<div class='sub-desc'><p>Configuration</p>\n<ul><li><span class='pre'>flowVersId</span> : String<div class='sub-desc'><p>Workflow version ID</p>\n</div></li><li><span class='pre'>clearUsers</span> : Boolean<div class='sub-desc'><p>Clears the owner name of the template</p>\n</div></li><li><span class='pre'>nameSubWorkflowTemplates</span> : Boolean<div class='sub-desc'><p>Clears the owner name of the template</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>JSON representation of the workflow diagram</p>\n</div></li></ul></div></div></div><div id='method-getWorkflowIconGuid' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflowIconGuid' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflowIconGuid' class='name expandable'>getWorkflowIconGuid</a>( <span class='pre'>iconName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the guid of a workflow icon ...</div><div class='long'><p>Returns the guid of a workflow icon</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>iconName</span> : String<div class='sub-desc'><p>Icon name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Workflow icon GUID</p>\n</div></li></ul></div></div></div><div id='method-getWorkflowStatus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflowStatus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflowStatus' class='name expandable'>getWorkflowStatus</a>( <span class='pre'>flow</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the Status of the workflow. ...</div><div class='long'><p>Returns the Status of the workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>flow</span> : String|de.elo.ix.client.WFDiagram<div class='sub-desc'><p>Either a flowId or WFDiagram (to avoid loading it again)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflowTemplate' class='name expandable'>getWorkflowTemplate</a>( <span class='pre'>workflowTemplateId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the workflow template ...</div><div class='long'><p>Returns the workflow template</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplateId</span> : String<div class='sub-desc'><p>Workflow template ID</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Workflow ID</p>\n</div></li></ul></div></div></div><div id='method-getWorkflowTemplateId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflowTemplateId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflowTemplateId' class='name expandable'>getWorkflowTemplateId</a>( <span class='pre'>workflowTemplateName</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the template ID of a workflow ...</div><div class='long'><p>Returns the template ID of a workflow</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplateName</span> : String<div class='sub-desc'><p>Name of the workflow template</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Workflow ID</p>\n</div></li></ul></div></div></div><div id='method-getWorkflowTemplateName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-getWorkflowTemplateName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-getWorkflowTemplateName' class='name expandable'>getWorkflowTemplateName</a>( <span class='pre'>workflowTemplateId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns the template name of a workflow ...</div><div class='long'><p>Returns the template name of a workflow</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplateId</span> : String<div class='sub-desc'><p>ID of the workflow template</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Workflow name</p>\n</div></li></ul></div></div></div><div id='method-hasActiveWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-hasActiveWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-hasActiveWorkflow' class='name expandable'>hasActiveWorkflow</a>( <span class='pre'>objId, [template]</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an object has at least on active workflow. ...</div><div class='long'><p>Checks, if an object has at least on active workflow.\nIf a template name is defined, the function checks, if there is at least one active workflow with this template.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>template</span> : String (optional)<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-importWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-importWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-importWorkflow' class='name expandable'>importWorkflow</a>( <span class='pre'>workflowName, file, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Imports a workflow into a specified file ...</div><div class='long'><p>Imports a workflow into a specified file</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowName</span> : String<div class='sub-desc'><p>Workflow name</p>\n</div></li><li><span class='pre'>file</span> : java.io.File<div class='sub-desc'><p>Import file</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>replaceMissingUserByUserId</span> : Boolean (optional)<div class='sub-desc'><p>Replace a missing user by this user ID</p>\n<p>Defaults to: <code>0</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Flow ID</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-isServiceWf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-isServiceWf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-isServiceWf' class='name expandable'>isServiceWf</a>( <span class='pre'>wfDiagram</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if a workflow was started from a service. ...</div><div class='long'><p>Checks, if a workflow was started from a service.</p>\n\n<p>Currently this is determined by the prefix at the workflow name retrieved by <a href=\"#!/api/sol.common.WfUtils-method-getServiceWfPrefix\" rel=\"sol.common.WfUtils-method-getServiceWfPrefix\" class=\"docClass\">getServiceWfPrefix</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadBaseConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-loadBaseConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-loadBaseConfig' class='name expandable'>loadBaseConfig</a>( <span class='pre'></span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Loads the base configuration from the JSON file: /Administration/Business Solutions/common/Configuration/base.config ...</div><div class='long'><p>Loads the base configuration from the JSON file: <code>/Administration/Business Solutions/common/Configuration/base.config</code></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mergeWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-mergeWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-mergeWorkflowTemplate' class='name expandable'>mergeWorkflowTemplate</a>( <span class='pre'>workflowTemplateName, params</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Merge workflow template\nAfter the workflow templateshave been imported via JSON with a timestamp suffix, they will be...</div><div class='long'><p>Merge workflow template\nAfter the workflow templateshave been imported via JSON with a timestamp suffix, they will be stored as a new working\nversion of the origin workflow and than the imported workflow will be deleted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowTemplateName</span> : String<div class='sub-desc'><p>Workflow template name</p>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Parameters</p>\n<ul><li><span class='pre'>mergeWorkflowTemplateSeparator</span> : String<div class='sub-desc'><p>Merge workflow separator</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Merged workflow template name</p>\n</div></li></ul></div></div></div><div id='method-parseAndCheckParams' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-parseAndCheckParams' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-parseAndCheckParams' class='name expandable'>parseAndCheckParams</a>( <span class='pre'>workflow, nodeId</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>This function parses the configuration object from a nodes comment. ...</div><div class='long'><p>This function parses the configuration object from a nodes comment.\nThe comment has to be valid JSON string.</p>\n\n<p>Additionally this method supports parsing the configuration from a config file (see <a href=\"#!/api/sol.common.ConfigMixin-method-parseConfiguration\" rel=\"sol.common.ConfigMixin-method-parseConfiguration\" class=\"docClass\">sol.common.ConfigMixin.parseConfiguration</a>).</p>\n\n<p>In addition there can be a variable number of string arguments for mandatory properties. If the configuration is missing one of those properties, an exception will be thrown.</p>\n\n<pre><code>var config = sol.common.ix.WfUtils.parseAndCheckParams(wf, 23, \"objId\", ...);\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflow</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>The WFDiagram containing the workflow description</p>\n</div></li><li><span class='pre'>nodeId</span> : String<div class='sub-desc'><p>The ID of the node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readWorkflowIconGuids' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-readWorkflowIconGuids' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-readWorkflowIconGuids' class='name expandable'>readWorkflowIconGuids</a>( <span class='pre'></span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Reads the workflow icon IDs ...</div><div class='long'><p>Reads the workflow icon IDs</p>\n</div></div></div><div id='method-renameWorkflowTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-renameWorkflowTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-renameWorkflowTemplate' class='name expandable'>renameWorkflowTemplate</a>( <span class='pre'>oldName, newName</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Renames workflow templates ...</div><div class='long'><p>Renames workflow templates</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>oldName</span> : String<div class='sub-desc'><p>Old name</p>\n</div></li><li><span class='pre'>newName</span> : String<div class='sub-desc'><p>New name</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-replaceSubTemplateNamesInWorkflowJson' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-replaceSubTemplateNamesInWorkflowJson' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-replaceSubTemplateNamesInWorkflowJson' class='name expandable'>replaceSubTemplateNamesInWorkflowJson</a>( <span class='pre'>workflowJson</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Replaces the sub workflow names by the sub workflow IDs ...</div><div class='long'><p>Replaces the sub workflow names by the sub workflow IDs</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>workflowJson</span> : String<div class='sub-desc'><p>Workflow JSON</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Workflow JSON with replaced sub workflow names</p>\n</div></li></ul></div></div></div><div id='method-setSessionOptionStartDocMaskWorkflows' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-setSessionOptionStartDocMaskWorkflows' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-setSessionOptionStartDocMaskWorkflows' class='name expandable'>setSessionOptionStartDocMaskWorkflows</a>( <span class='pre'>startDocMaskWorkflows</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the session option ´Start docmask workflows´ ...</div><div class='long'><p>Sets the session option ´Start docmask workflows´</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>startDocMaskWorkflows</span> : Boolean<div class='sub-desc'><p>Start doc mask workflows</p>\n</div></li></ul></div></div></div><div id='method-setWfMapValue' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-setWfMapValue' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-setWfMapValue' class='name expandable'>setWfMapValue</a>( <span class='pre'>objId, flowId, key, values</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets a map value from a workflow. ...</div><div class='long'><p>Sets a map value from a workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : Number<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>flowId</span> : String<div class='sub-desc'><p>Flow ID</p>\n</div></li><li><span class='pre'>key</span> : String<div class='sub-desc'><p>Map key</p>\n</div></li><li><span class='pre'>values</span> : String|Array<div class='sub-desc'><p>Value</p>\n</div></li></ul></div></div></div><div id='method-setWorkflowStatus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-setWorkflowStatus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-setWorkflowStatus' class='name expandable'>setWorkflowStatus</a>( <span class='pre'>wfDiagram, status</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the workflow status. ...</div><div class='long'><p>Sets the workflow status.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>wfDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'><p>Workflow diagram</p>\n</div></li><li><span class='pre'>status</span> : String<div class='sub-desc'><p>Workflow status</p>\n</div></li></ul></div></div></div><div id='method-startMaskStandardWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-startMaskStandardWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-startMaskStandardWorkflow' class='name expandable'>startMaskStandardWorkflow</a>( <span class='pre'>objId, [params]</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts the workflow defined as standard workflow for the mask or in an index field. ...</div><div class='long'><p>Starts the workflow defined as standard workflow for the mask or in an index field.\nIf there is already an workflow, it will do nothing and return the first active one.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'><p>Default will be the sord name</p>\n<ul><li><span class='pre'>name</span> : Object (optional)<div class='sub-desc'><p>Default will be the sord name</p>\n</div></li><li><span class='pre'>field</span> : Object (optional)<div class='sub-desc'><p>The field to read the workflow template from</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The workflow ID</p>\n</div></li></ul></div></div></div><div id='method-startWorkflow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.WfUtils'>sol.common.WfUtils</span><br/><a href='source/lib_sol.common.WfUtils.html#sol-common-WfUtils-method-startWorkflow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.WfUtils-method-startWorkflow' class='name expandable'>startWorkflow</a>( <span class='pre'>templFlowId, flowName, objId, [prio]</span> ) : Number<span class=\"signature\"></span></div><div class='description'><div class='short'>Starts a workflow. ...</div><div class='long'><p>Starts a workflow.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templFlowId</span> : String<div class='sub-desc'><p>Name or ID of the template which should be started</p>\n</div></li><li><span class='pre'>flowName</span> : String<div class='sub-desc'><p>Name of the new workflow</p>\n</div></li><li><span class='pre'>objId</span> : String<div class='sub-desc'><p>Object on which the workflow should be started</p>\n</div></li><li><span class='pre'>prio</span> : Number (optional)<div class='sub-desc'><p>If specified, the workflow priority will be changed (0=high, 1=medium, 2=low)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Number</span><div class='sub-desc'><p>The ID of the started workflow</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});